package org.nhindirect.gateway.smtp.james.mailet;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MailetProperties {

    private static final Log LOGGER = LogFactory.getFactory().getInstance(
            MailetProperties.class);
    private static Map<String, String> propertiesMap = null;

    public static Map<String, String> getPropertiesList() {
        return propertiesMap;
    }

    public static void setPropertiesList(Map<String, String> map) {
        propertiesMap = map;
    }

    public static Map<String, String> updatedPropertiesList() {
        Map<String, String> props = new HashMap<String, String>();
        Properties properties = getProperties();
        for (String key : properties.stringPropertyNames()) {
            props.put(key, properties.getProperty(key));
        }
        Connection conn = null;
        PreparedStatement prepQuery = null;
        ResultSet rs = null;
        try {
            conn = databaseConnect(props.get("mailet.db.hostname"), props.get("mailet.db.port"), props.get("mailet.db.configname"), props.get("mailet.db.instance"),
                    props.get("mailet.db.configusername"), props.get("mailet.db.configprd"));
            String sqlQuery = "select * from mailet_properties";
            if(conn == null){
            	LOGGER.error("Failed to connect to database. Check your database username and password.");
            	return null;
            }
            try {
                prepQuery = conn.prepareStatement(sqlQuery,
                        Statement.RETURN_GENERATED_KEYS);
            } catch (SQLException e) {
                LOGGER.error("Failed to execute query");
                return null;
            }
            if (prepQuery != null) {

                rs = prepQuery.executeQuery();
                Map<String, String> map = new HashMap<String, String>();
                while (rs.next()) {
                    String name = rs.getString("name");
                    String value = rs.getString("value");
                    map.put(name, value);
                }
                return map;
            } else {
                return null;
            }
        } catch (SQLException e) {
            return null;
        } finally {

            if (prepQuery != null) {
                try {
                    prepQuery.close();
                } catch (SQLException e) {
                    LOGGER.debug("Failed to close statement");
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    LOGGER.debug("Failed to close result set");
                }
            }
            try {
                if (conn != null) {
                    conn.close();
                }

            } catch (SQLException e) {
                LOGGER.debug("failed to close database connection");
            }
        }



    }

    private static Properties getProperties() {
        // Get system properties
        Properties properties = System.getProperties();
        InputStream propertiesFile = null;
        try {
            propertiesFile = NHINDSecurityAndTrustMailet.class
                    .getResourceAsStream("/mailet.properties");
            properties.load(propertiesFile);
        } catch (IOException e) {
            LOGGER.trace("Could not load mailet properties file");
        } finally {
            try {
                propertiesFile.close();
            } catch (IOException propCloseEx) {
                LOGGER.debug("Could not close mailet properties file");
            }
        }
        return properties;
    }

    private static Connection databaseConnect(String db_hostname,
            String db_port, String db_name, String db_instance,
            String db_userid, String db_prd) throws SQLException {
        Connection conn = null;
        String db_connect_string = "jdbc:sqlserver://" + db_hostname + ":"
                + db_port + ";databaseName=" + db_name
                + ";ssl=require;hostNameInCertificate=" + db_hostname
                + ";instanceName=" + db_instance + ";portNumber=" + db_port
                + ";trustServerCertificate=true";

        // Load DB Driver
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
        } catch (ClassNotFoundException f) {
            LOGGER.trace("Could not load SQL Server DB driver");
        }

        // Connect to DB
        try {
            conn = DriverManager.getConnection(db_connect_string, db_userid,
                    db_prd);
        } catch (SQLException sqlException) {
            LOGGER.trace("SQL Server database not reachable");
            return null;
        }

        return conn;
    }
    
    
}

